package it.eng.eremita.jpa.util;

import java.util.ArrayList;

import it.eng.eremita.graphql.types.Trackable;
import it.eng.eremita.graphql.types.Validable;
import it.eng.eremita.jpa.entity.Utente;
import it.eng.eremita.jpa.manager.Accessor;
import it.eng.eremita.jpa.manager.EremitaManager;

/**
 * Semplice schema di autorizzazione sugli oggetti
 * @author Favini_G
 *
 */
public class ObjectAuthorizer<X> {
	
	
	
	public boolean isAuthorized(Utente u, X x, String permissionType) {
		
		EremitaManager em = Accessor.getEremitaManager();
		
		if (Accessor.haPermesso(u, "PERMESSO_TUTTO")) return true;

		String nomeOggetto = em.getEntityClass(x).getSimpleName().toUpperCase();

		//tutti?
		String nomePermesso = "PERMESSO_" + permissionType + "_" + nomeOggetto;
		if (Accessor.haPermesso(u, nomePermesso)) return true;
		
		if (!(x instanceof Trackable)) return true;
		
		// tuo?
		Trackable t = (Trackable)x;
		Utente ut = (Utente)t.getUtenteCreazione();
		if (ut==null || u.equals(ut)) {
			nomePermesso = "PERMESSO_" + permissionType + "_OWN_" + nomeOggetto;
			if (Accessor.haPermesso(u, nomePermesso)) return true;
		}
		
		return false;
	}
	
	public boolean isAuthorized(Utente u, X x) {
		return isAuthorized(u,x,"WRITE");
	}
	
	public boolean canInsert(Utente u, X x) {
		return isAuthorized(u,x,"INSERT");
	}
	
	public String getQueryCondition(Utente u, X x, String aliasTabella) {
		if (Accessor.haPermesso(u, "PERMESSO_TUTTO")) return ""; //tutto di tutto
		
		EremitaManager em = Accessor.getEremitaManager();
		String nomeOggetto = em.getEntityClass(x).getSimpleName().toUpperCase();
		String nomePermesso = "PERMESSO_READ_" + nomeOggetto;
		if (Accessor.haPermesso(u, nomePermesso)) return ""; //tutto di questi
		
		ArrayList<String> condizioni = new ArrayList<>();
		
		if ((x instanceof Trackable)) {
			nomePermesso = "PERMESSO_READ_OWN_" + nomeOggetto;
			if (Accessor.haPermesso(u, nomePermesso)) {
				condizioni.add(aliasTabella+"utente_creazione = '"+u.getId()+"'");
				//return aliasTabella+"utente_creazione = '"+u.getId()+"'"; //solo se tuo
			}
		}
		
		if ((x instanceof Validable)) {
			nomePermesso = "PERMESSO_READVALIDATI_" + nomeOggetto;
			if (Accessor.haPermesso(u, nomePermesso)) {
				condizioni.add(aliasTabella+"validato = 'true'");
				//return aliasTabella+"utente_creazione = '"+u.getId()+"'"; //solo se tuo
			}
		}
		
		
		if (condizioni.size()==0) return "1=0"; //nada
		if (condizioni.size()==1) return condizioni.get(0);
		String sss = "(";
		for (int k=0; k<condizioni.size(); k++) {
			sss+="("+condizioni.get(k)+")";
			if (k<condizioni.size()-1) sss+=" or ";
		}
		sss+=")";
		return sss;
	}

}
